/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqListener;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqNotifier;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpIProgressUIListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqCollection;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqDOMReader;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqEvent;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqExecException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqInputException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteSet;
import oracle.sysman.oip.oipc.oipcp.OipcpResultDOMReader;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrRulesEngineFactory;
import oracle.sysman.oip.oipc.oipcr.OipcrRulesEngineInitException;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;

public class OipcpPrereqChecker
implements OipcpIProgressUIListener,
OipcpIPrereqNotifier,
OipcpIPrereqChecker {
    private OipcpPrereqCollection m_oPrereqCollection;
    private List m_prereqListeners;
    private String m_sPrereqConfigLoc;
    private String m_sPrereqResultsLoc;
    private String m_sRuleMapFile;
    private Collection m_oPrereqInputFiles;
    private OipcrIRulesEngine m_oRulesEngine;
    private OipcuPrereqProps m_oPrereqProps;
    private OipcpIPrereqResultsSummary m_oResultsSummary;
    private boolean m_bSessionCancelled;
    private static Vector s_saAlreadyCopied = new Vector();
    private OipcpPrereqCollection m_oPrereqResultCollection;
    private OipcpIPrereqResultsSummary m_oResultsSummaryRemote;
    private OipcpPrerequisiteSet oEntrySetResult = null;
    public static final String S_PREREQ_INPUT_PROP_NAME = "prerequisite_input";
    private static boolean executeRemotePrereqs = false;
    private HashMap resultPrereqRemoteNode;
    String[] remoteNodes;
    String scratchPath = System.getProperty("oracle.installer.scratchPath");
    String sInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
    String sOracleHomLoc = System.getProperty("oracle.installer.ORACLE_HOME");
    String sInvLoc = System.getProperty("oracle.installer.inventory_location");
    public static final int s_curPlatformId = OiixPlatform.getCurrentPlatform();
    public static final int s_curPlatformGroup = OiixPlatform.getPlatGroup((int)s_curPlatformId);

    protected OipcpPrereqChecker(OipcuPrereqProps oPrereqProps) {
        this.m_prereqListeners = new ArrayList(5);
        this.m_sPrereqConfigLoc = oPrereqProps.getConfigLoc();
        this.m_sPrereqResultsLoc = oPrereqProps.getResultsLoc();
        this.m_oPrereqInputFiles = oPrereqProps.getPrereqInputFiles();
        this.m_sRuleMapFile = oPrereqProps.getPropertyValue("rulemap");
        this.m_oPrereqProps = oPrereqProps;
        this.m_oResultsSummary = new OipcpPrereqResultsSummary();
        this.m_bSessionCancelled = false;
        this.resultPrereqRemoteNode = new HashMap(1);
        executeRemotePrereqs = false;
    }

    public void initialize() throws OipcrRulesEngineInitException {
        this.m_oRulesEngine = OipcrRulesEngineFactory.getRulesEngine(this.getPrereqConfigLoc(), this.getPrereqResultsLoc(), this.getPrereqProps());
        this.m_oRulesEngine.initialize();
    }

    public String getPrereqConfigLoc() {
        return this.m_sPrereqConfigLoc;
    }

    public void setPrereqConfigLoc(String sPrereqConfigLoc) {
        this.m_sPrereqConfigLoc = sPrereqConfigLoc;
    }

    public String getPrereqResultsLoc() {
        return this.m_sPrereqResultsLoc;
    }

    public void setPrereqResultsLoc(String sPrereqResultsLoc) {
        this.m_sPrereqResultsLoc = sPrereqResultsLoc;
    }

    public Collection getPrereqInputFiles() {
        return this.m_oPrereqInputFiles;
    }

    public void setPrereqInputFiles(Collection oPrereqInputFiles) {
        this.m_oPrereqInputFiles = oPrereqInputFiles;
    }

    public void setPrereqInputFile(String sPrereqInputFile) {
        ArrayList<String> oPrereqInputFiles = new ArrayList<String>();
        oPrereqInputFiles.add(sPrereqInputFile);
        this.setPrereqInputFiles(oPrereqInputFiles);
    }

    public String getRuleMap() {
        return this.m_sRuleMapFile;
    }

    public void setRuleMap(String sRuleMap) {
        this.m_sRuleMapFile = sRuleMap;
    }

    public OipcrIRulesEngine getRuleEngine() {
        return this.m_oRulesEngine;
    }

    public void setRuleEngine(OipcrIRulesEngine oRuleEngine) {
        this.m_oRulesEngine = oRuleEngine;
    }

    public OipcuPrereqProps getPrereqProps() {
        return this.m_oPrereqProps;
    }

    public synchronized OipcpIPrereqResultsSummary getResultsSummary() {
        return this.m_oResultsSummary;
    }

    public synchronized void setSessionCancelled(boolean bCancel) {
        this.m_bSessionCancelled = bCancel;
    }

    public synchronized boolean isSessionCancelled() {
        return this.m_bSessionCancelled;
    }

    public void addPrereqListener(OipcpIPrereqListener oListener) {
        this.m_prereqListeners.add(oListener);
    }

    public void removePrereqListener(OipcpIPrereqListener oListener) {
        this.m_prereqListeners.remove(oListener);
    }

    public void executePrereqs(String sEntryPoint) throws OipcpPrereqExecException {
        try {
            this.loadPrereqs();
        }
        catch (OipcpPrereqInputException pie) {
            throw new OipcpPrereqExecException(pie.getMessage(), (Throwable)((Object)pie));
        }
        OipcpPrerequisiteSet oEntrySet = this.m_oPrereqCollection.getPrereqSet(sEntryPoint);
        if (oEntrySet == null) {
            System.err.println("No checks to execute for entry point:" + sEntryPoint + "Please check input files");
            throw new OipcpPrereqExecException("No checks found");
        }
        OiixSet oChecks = oEntrySet.getContainedChecks();
        if (oChecks == null || oChecks.size() == 0) {
            System.err.println("No checks to execute.Please check the input files");
            throw new OipcpPrereqExecException("No checks found");
        }
        Vector vChecks = oEntrySet.getContainedChecks().elementsVect();
        this.notifyPrereqEvent(0, vChecks);
        this.runChecks(vChecks);
        this.notifyPrereqEvent(1, this.m_oResultsSummary);
    }

    public void loadPrereqs() throws OipcpPrereqInputException {
        if (this.m_oPrereqCollection == null) {
            OipcpPrereqDOMReader oReader = new OipcpPrereqDOMReader(this.getPrereqInputFiles());
            this.m_oPrereqCollection = oReader.buildPrereqCollection();
        }
    }

    public boolean entryPointExists(String sEntryPoint) throws OipcpPrereqInputException {
        OipcpPrerequisiteSet oEntrySet;
        if (this.m_oPrereqCollection == null) {
            this.loadPrereqs();
        }
        return (oEntrySet = this.m_oPrereqCollection.getPrereqSet(sEntryPoint)) != null;
    }

    public void runChecks(Vector vChecks) throws OipcpPrereqExecException {
        Vector<OipcpPrerequisiteCheck> vSkippedChecks = new Vector<OipcpPrerequisiteCheck>(vChecks.size());
        try {
            int numChecks = vChecks.size();
            for (int i = 0; i < numChecks; ++i) {
                OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)vChecks.elementAt(i);
                OipcpPrerequisiteResult oPrereqResult = null;
                this.notifyPrereqEvent(2, oCheck);
                if (this.isSessionCancelled()) {
                    vSkippedChecks.add(oCheck);
                    oPrereqResult = new OipcpPrerequisiteResult();
                    oCheck.setResult(oPrereqResult);
                } else {
                    oPrereqResult = this.executeCheck(oCheck);
                }
                this.updateResultsSummary(oCheck);
                this.notifyPrereqEvent(3, oCheck);
            }
            if (this.isSessionCancelled()) {
                this.notifyPrereqEvent(8, vSkippedChecks);
                this.setSessionCancelled(false);
            }
        }
        catch (OipcrExecuteRuleException re) {
            if (re.getCause() != null) {
                re.getCause().printStackTrace();
            }
            throw new OipcpPrereqExecException(re.getMessage(), (Throwable)((Object)re));
        }
    }

    private OipcpPrerequisiteResult executeCheck(OipcpPrerequisiteCheck oCheck) throws OipcrExecuteRuleException {
        OipcpPrerequisiteResult oPrereqResult = null;
        if (this.isManualCheck(oCheck)) {
            oPrereqResult = new OipcpPrerequisiteResult();
            oCheck.setResult(oPrereqResult);
        } else {
            OipcrIResult oResult = this.m_oRulesEngine.executeRule(oCheck.getRuleSet(), oCheck.getRule(), oCheck.getRefFile());
            oPrereqResult = new OipcpPrerequisiteResult(oResult);
            oCheck.setResult(oPrereqResult);
        }
        return oPrereqResult;
    }

    private boolean isManualCheck(OipcpPrerequisiteCheck oCheck) {
        return oCheck.getExecutionMode() == 1;
    }

    public void notifyPrereqEvent(int nEventId, Object oEventInfo) {
        OipcpPrereqEvent oEvent = new OipcpPrereqEvent(nEventId, oEventInfo);
        int numListeners = this.m_prereqListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            OipcpIPrereqListener oListener = (OipcpIPrereqListener)this.m_prereqListeners.get(i);
            oListener.onPrereqEvent(oEvent);
        }
    }

    private void updateResultsSummary(OipcpPrerequisiteCheck oCheck) {
        OipcpPrerequisiteResult oResult = oCheck.getResult();
        if (oResult != null) {
            if (oResult.isSuccess()) {
                this.m_oResultsSummary.addToSuccessfulChecks(oCheck);
            } else if (oResult.isFailed()) {
                if (oCheck.isRequired()) {
                    this.m_oResultsSummary.addToFailedChecks(oCheck);
                } else {
                    this.m_oResultsSummary.addToWarnings(oCheck);
                }
                this.m_oResultsSummary.addToRetryList(oCheck);
            } else if (oResult.isSkipped()) {
                this.m_oResultsSummary.addToUserVerifyList(oCheck);
                this.m_oResultsSummary.addToRetryList(oCheck);
            }
            this.m_oResultsSummary.addToAllChecks(oCheck);
        }
    }

    public void onPrereqStop() {
        this.setSessionCancelled(true);
    }

    public void onPrereqRetry() {
        final Vector v = (Vector)this.m_oResultsSummary.getChecksToRetry().clone();
        this.m_oResultsSummary.resetForRetry();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (Boolean.getBoolean("oracle.installer.dynamicLoadOnPrereqRetry")) {
                        OipcpPrereqChecker.this.m_oRulesEngine.dispose();
                        OipcpPrereqChecker.this.m_oRulesEngine.initialize();
                    }
                    OipcpPrereqChecker.this.runChecks(v);
                    OipcpPrereqChecker.this.notifyPrereqEvent(5, OipcpPrereqChecker.this.getResultsSummary());
                }
                catch (OipcpPrereqExecException pe) {
                    pe.printStackTrace();
                }
                catch (OipcrRulesEngineInitException re) {
                    re.printStackTrace();
                }
            }
        };
        this.notifyPrereqEvent(4, v);
        Thread retryThread = new Thread(runnable);
        retryThread.start();
    }

    public void onPrereqContinue() {
    }

    public void onPrereqSuspend() {
    }

    public OipcpIProgressUIListener getProgressUIListener() {
        return this;
    }

    public void dispose() {
        if (this.m_oRulesEngine != null) {
            this.m_oRulesEngine.dispose();
        }
        this.m_oRulesEngine = null;
        this.m_oPrereqCollection = null;
        this.m_oPrereqProps = null;
    }

    public void executeRemotePrereqs(String sEntryPoint) throws OipcpPrereqExecException {
        this.executeRemotePrereqs(sEntryPoint, this.sOracleHomLoc);
    }

    public void executeRemotePrereqs(String sEntryPoint, String oracleHome) throws OipcpPrereqExecException {
        if (!this.getExecuteRemotePrereqs()) {
            return;
        }
        String prefixRunCmd = "/oui/bin/runInstaller PREREQ_CONFIG_LOCATION=";
        String prereqConfigLocConst = " PREREQ_CONFIG_LOCATION";
        String CLUSTERPARAMFILE = "clusterparam.ini";
        String prereqConfigLoc = System.getProperty("oracle.installer.prereqConfigLoc");
        prereqConfigLoc = OiixPathOps.getNativeForm((String)prereqConfigLoc);
        String sOUILoc = System.getProperty("oracle.installer.oui_loc");
        String OUI_EXEC_UNIX = "runInstaller";
        String OUI_EXEC_WINDOWS = "setup.exe";
        String sOUIExecLoc = null;
        String s_paramFile = OiixPathOps.concatPath((String)sOUILoc, (String)CLUSTERPARAMFILE);
        String logLocAtRemoteNodes = OiixPathOps.concatPath((String)this.scratchPath, (String)"logs");
        logLocAtRemoteNodes = OiixPathOps.getNativeForm((String)logLocAtRemoteNodes);
        String sExecLoc = OiixPathOps.concatPath((String)sOUILoc, (String)"bin");
        String jreLogLoc = System.getProperty("oracle.installer.jre_loc");
        String cmdToRun = "";
        String sOracleHomeName = System.getProperty("oracle.installer.ORACLE_HOME_NAME");
        String serviceNameIfWindows = "OracleOUI" + sOracleHomeName + "Service";
        String[] nodeList = this.getRemoteNodes();
        int nodeNameLen = nodeList.length;
        String nodeName = null;
        boolean fileNotNull = false;
        OipcpResultDOMReader oReaderResult = null;
        OiipgClusterRunCmd runCmdOnNodes = new OiipgClusterRunCmd();
        OiiolTextLogger.appendText((String)("Setting  getPrereqConfigLoc to " + this.getPrereqConfigLoc() + "."));
        OiiolTextLogger.appendText((String)("Setting System.getProperty() to " + System.getProperty("oracle.installer.prereqConfigLoc") + "."));
        OiiolTextLogger.appendText((String)("Setting scratchPath to " + this.scratchPath + "."));
        OiiolTextLogger.appendText((String)("Setting prereqConfigLoc to " + prereqConfigLoc + "."));
        OiiolTextLogger.appendText((String)("Setting logLocAtRemoteNodes to " + logLocAtRemoteNodes + "."));
        OiiolTextLogger.appendText((String)("Setting serviceNameIfWindows to " + serviceNameIfWindows + "."));
        OiiolTextLogger.appendText((String)("Setting jreLoc to " + jreLogLoc + "."));
        OiiolTextLogger.appendText((String)("Setting paramFile to " + s_paramFile + "."));
        if (s_curPlatformGroup == -1) {
            sOUIExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OUI_EXEC_UNIX);
        } else if (s_curPlatformGroup == -3) {
            sOUIExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OUI_EXEC_WINDOWS);
        }
        File f = new File(sOUIExecLoc);
        if (!f.exists()) {
            sExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OiixPlatform.getCurrentPlatformDirectoryName());
            if (s_curPlatformGroup == -1) {
                sOUIExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OUI_EXEC_UNIX);
            }
        }
        sOUIExecLoc = OiixPathOps.getNativeForm((String)sOUIExecLoc);
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        OiipgClusterRunCmd ocrC = new OiipgClusterRunCmd();
        if (!isAPIMode && Boolean.getBoolean("oracle.installer.bootstrap") || isAPIMode) {
            Vector newNodeList = OiixVectorOps.arrayToVect((Object)nodeList);
            Vector nodesToBootstrap = OiixVectorOps.subtract((Vector)newNodeList, (Vector)s_saAlreadyCopied);
            if (nodesToBootstrap == null || nodesToBootstrap.size() == 0) {
                return;
            }
            String[] nodesToBootstrapArr = OiixVectorOps.list2StrArr((List)nodesToBootstrap);
            ClusterCmd clsCmd = ocrC.getClusterCmdObj();
            try {
                clsCmd.transferDirToNodes(nodesToBootstrapArr, this.scratchPath, null);
                OiixVectorOps.unionInPlace((Vector)s_saAlreadyCopied, (Vector)nodesToBootstrap);
            }
            catch (ClusterException ce) {
                try {
                    Object[] args = new String[]{this.scratchPath, ce.getMessage()};
                    OiipgClusterOps.throwRemoteOpsException((String)"OUI-35031", (Object[])args, (Throwable)ce);
                }
                catch (OiipgRemoteOpsException fe) {
                    System.err.println("exception is " + (Object)((Object)fe));
                }
            }
            catch (RemoteFileOperationException rfoe) {
                try {
                    String[] args = new String[]{this.scratchPath, rfoe.getMessage()};
                    Vector nodesOK = new Vector();
                    String exceptionMsg = OiipgClusterOps.constructOiipgRemoteFileOperationException((String)"OUI-35031", (String[])args, (RemoteFileOperationException)rfoe, (String[])nodesToBootstrapArr, nodesOK);
                    OiixVectorOps.unionInPlace((Vector)s_saAlreadyCopied, nodesOK);
                    throw new OiipgRemoteFileOperationException(exceptionMsg, rfoe);
                }
                catch (OiipgRemoteFileOperationException e) {
                    System.err.println("Exception is " + (Object)((Object)e));
                }
            }
        }
        cmdToRun = cmdToRun.concat(sOUIExecLoc);
        if (this.sInvPtrLoc != null && this.sInvPtrLoc.trim().length() > 0) {
            cmdToRun = cmdToRun + " -invPtrLoc \"" + this.sInvPtrLoc + "\"";
        }
        if (this.sInvLoc != null) {
            cmdToRun = cmdToRun + " \"INVENTORY_LOCATION=" + this.sInvLoc + "\"";
        }
        if (OiixPlatform.getPlatGroup((int)OiixPlatform.getCurrentPlatform()) == -1) {
            cmdToRun = cmdToRun.concat(" -prereqchecker  -entryPoint \"" + sEntryPoint + "\"" + " -silent -ignoreSysPrereqs -prereqLogLoc " + logLocAtRemoteNodes + " -jreLoc " + jreLogLoc + " -noclusterenabled" + prereqConfigLocConst + "=" + prereqConfigLoc);
        }
        if (OiixPlatform.getPlatGroup((int)OiixPlatform.getCurrentPlatform()) == -3) {
            cmdToRun = cmdToRun.concat(" -prereqchecker  -entryPoint \"" + sEntryPoint + "\"" + " -silent -ignoreSysPrereqs -prereqLogLoc " + logLocAtRemoteNodes + " -jreLoc " + jreLogLoc + " -noclusterenabled" + prereqConfigLocConst + "=" + prereqConfigLoc);
        }
        if (new File(s_paramFile).exists()) {
            cmdToRun = cmdToRun.concat(" -paramFile " + s_paramFile);
        } else {
            OiiolTextLogger.appendText((String)("clusterparam.ini does not exist at location:" + s_paramFile));
        }
        if (oracleHome != null && oracleHome.length() != 0 && !oracleHome.equalsIgnoreCase("")) {
            cmdToRun = cmdToRun.concat(" oracle.installer.ORACLE_HOME=" + oracleHome);
        }
        OiiolTextLogger.appendText((String)("Command to be executed is " + cmdToRun));
        try {
            if (OiixPlatform.getPlatGroup((int)OiixPlatform.getCurrentPlatform()) == -1) {
                runCmdOnNodes.runAnyCmdOnNodes(cmdToRun, nodeList, null);
            } else if (OiixPlatform.getPlatGroup((int)OiixPlatform.getCurrentPlatform()) == -3) {
                runCmdOnNodes.runAnyCmdOnNodes(cmdToRun, nodeList, serviceNameIfWindows);
            }
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
        for (int i = 0; i < nodeNameLen; ++i) {
            this.m_oResultsSummaryRemote = new OipcpPrereqResultsSummary();
            nodeName = nodeList[i];
            fileNotNull = false;
            try {
                Collection files = new ArrayList();
                String logLocname = "";
                logLocname = OiixPathOps.concatPath((String)logLocAtRemoteNodes, (String)"results");
                logLocname = OiixPathOps.getNativeForm((String)logLocname);
                files = this.getPrereqResultFiles(logLocname, nodeName);
                Iterator checkFilesForNull = files.iterator();
                while (checkFilesForNull.hasNext()) {
                    if (checkFilesForNull.next() != null) continue;
                    fileNotNull = true;
                    break;
                }
                if (!fileNotNull) {
                    oReaderResult = new OipcpResultDOMReader(files);
                    this.m_oPrereqResultCollection = oReaderResult.buildPrereqCollection();
                }
            }
            catch (OipcpPrereqInputException pie) {
                throw new OipcpPrereqExecException(pie.getMessage(), (Throwable)((Object)pie));
            }
            if (!fileNotNull) {
                this.oEntrySetResult = this.m_oPrereqResultCollection.getPrereqSet(sEntryPoint);
                if (this.oEntrySetResult == null) {
                    System.err.println("No checks to execute for entry point:" + sEntryPoint + "Please check input files");
                    throw new OipcpPrereqExecException("No checks found");
                }
                OiixSet oChecks = this.oEntrySetResult.getContainedChecks();
                if (oChecks == null || oChecks.size() == 0) {
                    System.err.println("No checks to execute.Please check the input files");
                    throw new OipcpPrereqExecException("No checks found");
                }
                Vector vChecks = this.oEntrySetResult.getContainedChecks().elementsVect();
                Vector<OipcpPrerequisiteCheck> vSkippedChecks = new Vector<OipcpPrerequisiteCheck>(vChecks.size());
                try {
                    int numChecks = vChecks.size();
                    for (int j = 0; j < numChecks; ++j) {
                        OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)vChecks.elementAt(j);
                        OipcpPrerequisiteResult oPrereqResult = null;
                        if (this.isSessionCancelled()) {
                            vSkippedChecks.add(oCheck);
                            oPrereqResult = new OipcpPrerequisiteResult();
                            oCheck.setResult(oPrereqResult);
                        } else {
                            oPrereqResult = this.executeCheck(oCheck);
                        }
                        OipcpPrerequisiteResult oResult = oCheck.getResult();
                        if (oResult == null) continue;
                        if (oResult.isSuccess()) {
                            this.m_oResultsSummaryRemote.addToSuccessfulChecks(oCheck);
                        } else if (oResult.isFailed()) {
                            if (oCheck.isRequired()) {
                                this.m_oResultsSummaryRemote.addToFailedChecks(oCheck);
                            } else {
                                this.m_oResultsSummaryRemote.addToWarnings(oCheck);
                            }
                            this.m_oResultsSummaryRemote.addToRetryList(oCheck);
                        } else if (oResult.isSkipped()) {
                            this.m_oResultsSummaryRemote.addToUserVerifyList(oCheck);
                            this.m_oResultsSummaryRemote.addToRetryList(oCheck);
                        }
                        this.m_oResultsSummaryRemote.addToAllChecks(oCheck);
                    }
                    if (this.isSessionCancelled()) {
                        this.notifyPrereqEvent(8, vSkippedChecks);
                        this.setSessionCancelled(false);
                    }
                }
                catch (OipcrExecuteRuleException re) {
                    if (re.getCause() != null) {
                        re.getCause().printStackTrace();
                    }
                    throw new OipcpPrereqExecException(re.getMessage(), (Throwable)((Object)re));
                }
                this.resultPrereqRemoteNode.put(nodeName, this.m_oResultsSummaryRemote);
                continue;
            }
            this.resultPrereqRemoteNode.put(nodeName, null);
        }
    }

    public Collection getPrereqResultFiles(String locAtLocalNode, String nodeName) {
        String localNodeDestName;
        Iterator oVal = this.m_oPrereqProps.getFilesListForProperty(S_PREREQ_INPUT_PROP_NAME);
        boolean exceptionCaught = false;
        ArrayList<String> oFiles = new ArrayList<String>();
        String oldFormat = ".xml";
        String newFormatRemote = "_results.xml";
        String newFormatLocal = "_" + nodeName + "_results.xml";
        String fileName = "";
        String fileNameTemp = localNodeDestName = OiixPathOps.concatPath((String)locAtLocalNode, (String)nodeName);
        String sDir = "";
        if (oVal != null) {
            while (oVal.hasNext()) {
                exceptionCaught = false;
                String fileNameDB = (String)oVal.next();
                fileName = OiixPathOps.concatPath((String)locAtLocalNode, (String)fileNameDB);
                fileName = OiixPathOps.getNativeForm((String)fileName);
                fileName = fileName.replace(oldFormat, newFormatRemote);
                fileNameDB = OiixPathOps.concatPath((String)this.scratchPath, (String)fileNameDB);
                int iSep = (fileNameDB = fileNameDB.replace(oldFormat, newFormatLocal)).lastIndexOf(47);
                if (iSep != -1) {
                    sDir = fileNameDB.substring(0, iSep + 1);
                }
                fileNameDB = fileNameDB.replaceFirst(sDir, "");
                fileNameDB = OiixPathOps.getNativeForm((String)fileNameDB);
                try {
                    OiipgClusterOps.transferFileFromNode((String)nodeName, (String)fileName, (String)fileNameDB);
                }
                catch (OiipgRemoteOpsException fe) {
                    System.err.println("Exception is " + (Object)((Object)fe));
                    exceptionCaught = true;
                }
                if (exceptionCaught) {
                    oFiles.add(null);
                    continue;
                }
                oFiles.add(fileNameDB);
            }
            oVal = null;
            return oFiles;
        }
        return null;
    }

    public OipcpIPrereqResultsSummary getPrereqResultObj(String nodeName) {
        return (OipcpIPrereqResultsSummary)this.resultPrereqRemoteNode.get(nodeName);
    }

    public void setExecuteRemotePrereqs(boolean bRemotePrereqs) {
        executeRemotePrereqs = bRemotePrereqs;
    }

    public boolean getExecuteRemotePrereqs() {
        return executeRemotePrereqs;
    }

    public void setRemoteNodes(String[] remoteNodesParam) {
        this.remoteNodes = remoteNodesParam;
    }

    public String[] getRemoteNodes() {
        return this.remoteNodes;
    }
}

